LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY RECONT IS

	PORT
	(
		D		: IN 	STD_LOGIC_VECTOR(4 downto 0);
		RE_W	: IN	STD_LOGIC;
		B_IOWN	: IN	STD_LOGIC;
		B_RESET	: IN	STD_LOGIC;
		RE_UL	: OUT	STD_LOGIC;
		RE_XY	: OUT	STD_LOGIC;
		RE_CS	: OUT	STD_LOGIC;
		RE_RX	: OUT	STD_LOGIC;
		RE_RY	: OUT	STD_LOGIC);
END RECONT;

ARCHITECTURE RTL OF RECONT IS
	SIGNAL	C: STD_LOGIC;
BEGIN
C <= RE_W and not B_IOWN;
process(C,B_RESET)
	begin
			if (B_RESET='1') then
				RE_UL <= '0';
				RE_XY <= '0';
				RE_CS <= '0';
				RE_RX <= '0';
				RE_RY <= '0';
			else
				IF (C'event and C='1') then
				RE_UL <= D(0);
				RE_XY <= D(1);
				RE_CS <= D(2);
				RE_RX <= D(3);
				RE_RY <= D(4);
			end if;
		end if;
	end process;
END RTL;



