/************************************************/
/*                                              */
/*   task01.c                                   */
/*   title: ȈʒuF^XN                  */
/*                                              */
/*  version: 1.1 		 Jun,24,1999 by A.Sugimoto  */
/************************************************/


#include "mirx68k.h"
#include "hard.h"

#define PI	3.1415926535f	/* ~ */
#define PI2	(PI*2.f)	/* 2 */
#define PIH	(PI/2.f)	/* /2 */

#define DEG	(180.f/PI)	/* 180/΁iʓx@̃f[^360@ɒj */
#define DT	0.03f	/* Tv[sec] */
#define D	0.0715f	/* ^C̒a[m] */
#define RG	16.f	/* M */
#define PPR	400.f	/* ^C]ŔpX[pulse/r] */
#define B_CCW	0.1208f /* ^CԊûP^Q[m] TOeXg for CCW */
#define B_CW	0.12423f /* ^CԊûP^Q[m] TOeXg for CW */

#define COEF	((PIH*D)/(PPR*RG*DT))	
#define Kv	COEF
#define Ko_CW	(COEF/B_CW)
#define Ko_CCW	(COEF/B_CCW)

#define INIT_X (0.f)
#define INIT_Y (0.f)
#define INIT_TH PI

extern float cosf(float);
extern float sinf(float);

void inzt01(){
	sys0(1,0x1010);
  sys2(1,3,0,0);/* Timer Task Interval 30 ms */
  sys4(1);
	sys8(1,1,(int)(INIT_X*100.f));
	sys8(1,2,(int)(INIT_Y*100.f));
	sys8(1,3,(int)(INIT_TH*DEG));
	sys3(1,0);
	re_ts_init();
}

void nrmt01(int prm1,int prm2)
{
}

void timt01(int prm1,int prm2){

	static float	om=0.f,	/* px[rad/s] */
			re_x=INIT_X,	/* W[cm] */
			re_y=INIT_Y,	/* W[cm] */
			re_th=INIT_TH;	/* px[rad] */

	RE_TS_DATA	data;

	float	v,	/* x[m/s] */
		om_old;

	data=re_ts_data();

	/*݈ʒǔvZ */
	v=Kv*(float)(data.r+data.l);
	om_old=om;
	om=((data.r>data.l)*Ko_CCW+(data.r<data.l)*Ko_CW)*(float)(data.r-data.l);
	re_th+=((om+om_old)*DT)/2.f;

	/* px̒ */
	while(re_th<0.f){
		re_th+=PI2;
	}
	while(re_th>=PI2){
		re_th-=PI2;
	}
	
	re_x+=(v*DT*sinf(re_th))*100.f;
	re_y-=(v*DT*cosf(re_th))*100.f;
	
	if(re_x > 250.f) re_x = 250.f;
	if(re_x < 0.f) re_x = 0.f;
	if(re_y > 250.f) re_y = 250.f;
	if(re_y < 0.f) re_y = 0.f;

	sys8(1,1,(int)(re_x));
	sys8(1,2,(int)(re_y));
	sys8(1,3,(int)(re_th*DEG));
}

interrupt void intt01(){
}
