LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY MPC_LATCH IS
	PORT
	(
		B_DATA		: IN	STD_LOGIC_VECTOR(7 downto 0);
		B_IOWN		: IN	STD_LOGIC;
		B_RESET		: IN	STD_LOGIC;
		MPC_ADD		: IN	STD_LOGIC;
		DATA		: OUT	STD_LOGIC_VECTOR(6 downto 0);
		DIR			: OUT	STD_LOGIC;
		NOW_DATA	: OUT	STD_LOGIC_VECTOR(7 downto 0));
END MPC_LATCH;

ARCHITECTURE RTL OF MPC_LATCH IS
	SIGNAL	WRITE	: STD_LOGIC;
begin
WRITE <= MPC_ADD and not B_IOWN;
process(WRITE,B_RESET)
begin
	if (B_RESET='1') then
		DATA <= "0000000";
		DIR <= '1';
		NOW_DATA <= "00000000";
	else
		if (WRITE'event and WRITE='1') then
			DATA <= B_DATA(6 downto 0);
			DIR <= B_DATA(7);
			NOW_DATA <= B_DATA;
		end if;
	end if;
end process;
end RTL;


