LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY MPC_CTRL IS
	PORT
	(
		NOW_DATA	: IN	STD_LOGIC_VECTOR(7 downto 0);
		B_IORN		: IN	STD_LOGIC;
		MPC_ADD		: IN	STD_LOGIC;
		DATA_OUT	: INOUT	STD_LOGIC_VECTOR(7 downto 0));
END MPC_CTRL;

ARCHITECTURE RTL OF MPC_CTRL IS
	SIGNAL	READ	: STD_LOGIC;
begin
READ <= MPC_ADD and not B_IORN;
process(READ,NOW_DATA)
begin
	if (READ='1') then
		DATA_OUT <= NOW_DATA;
	else 
		DATA_OUT <= "ZZZZZZZZ";
	end if;
end process;
end RTL;
