LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY rtencoder IS
	PORT
	(
		A,B,RESET,CLK			:IN 	STD_LOGIC;
		COUNT					:OUT	STD_LOGIC_VECTOR(15 downto 0));
END rtencoder;

ARCHITECTURE RTL OF rtencoder IS
	SIGNAL BEFORE_A	: STD_LOGIC_VECTOR(2 downto 0);
	SIGNAL BEFORE_B	: STD_LOGIC_VECTOR(2 downto 0);
	SIGNAL C_in : integer range 0 to 65535;
BEGIN
	process(RESET,CLK)
		BEGIN
		if(RESET ='1') then
			C_in <= 0;
			else
			if (CLK'event and CLK='1') then
				BEFORE_A(2) <= BEFORE_A(1);
				BEFORE_A(1) <= BEFORE_A(0);
				BEFORE_A(0) <= A;
				BEFORE_B(2) <= BEFORE_B(1);
				BEFORE_B(1) <= BEFORE_B(0);
				BEFORE_B(0) <= B;
				if (BEFORE_A(1)='1' and BEFORE_B(1)='0' and BEFORE_A(2)='0' and BEFORE_B(2)='0') then
					C_in <= C_in+1;
				elsif (BEFORE_A(1)='0' and BEFORE_B(1)='1' and BEFORE_A(2)='0' and BEFORE_B(2)='0') then
					C_in <= C_in-1;
				end if;
			end if;
			end if;
	END PROCESS;
COUNT <= CONV_STD_LOGIC_VECTOR(C_in,16);
END RTL;

