LIBRARY ieee;
USE ieee.std_logic_1164.all;
USE ieee.std_logic_arith.all;

ENTITY COUNTCONT IS

	PORT
	(
		X_DATA		: IN 	STD_LOGIC_VECTOR(15 downto 0);
		Y_DATA		: IN 	STD_LOGIC_VECTOR(15 downto 0);
		RESET		: IN	STD_LOGIC;
		CLK			: IN	STD_LOGIC;
		B_IORN		: IN	STD_LOGIC;
		RE_X		: IN	STD_LOGIC;
		RE_Y		: IN	STD_LOGIC;
		OUT_DATA	: OUT 	STD_LOGIC_VECTOR(15 downto 0));
END COUNTCONT;

ARCHITECTURE RTL OF COUNTCONT IS
		SIGNAL	LATCH_X	: STD_LOGIC_VECTOR(15 downto 0);
		SIGNAL	LATCH_Y	: STD_LOGIC_VECTOR(15 downto 0);


BEGIN

process(B_IORN,CLK)
begin
	if (CLK'event and CLK='1') then
		if (B_IORN = '0') then
			LATCH_X <= X_DATA;
			LATCH_Y <= Y_DATA;
		end if;
	end if;
end process;
process(RE_X,RE_Y,B_IORN,RESET)
	begin
		if (RESET = '1') then
			OUT_DATA <= "0000000000000000";
		else
			if (RE_X='1' and B_IORN='0') then
				OUT_DATA <= LATCH_X;
			elsif (RE_Y='1' and B_IORN='0') then
				OUT_DATA <= LATCH_Y;
			else
				OUT_DATA <= "ZZZZZZZZZZZZZZZZ";
			end if;
		end if;
end process;
END RTL;





