library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;

entity lat is
	port(
			CLK		:	IN	STD_LOGIC;
			IRS 	:	IN	STD_LOGIC;
			RESET 	:	IN	STD_LOGIC;
			C20_OUT	:	IN	STD_LOGIC;
			C20_0	:	IN	STD_LOGIC;
			C_OUT	:	OUT	STD_LOGIC
	);
END lat;

ARCHITECTURE RTL OF lat IS

	SIGNAL	COUNT_DUM	:	STD_LOGIC;
	
	BEGIN

		PROCESS(CLK,RESET)
			BEGIN
				IF(RESET = '1') THEN
					C_OUT <= '0';
				ELSIF(CLK'EVENT AND CLK = '1')THEN
					C_OUT <= COUNT_DUM;

					IF(C20_0 = '1')THEN
						IF(IRS = '1')THEN
							COUNT_DUM <= IRS;
						ELSE
							COUNT_DUM <= COUNT_DUM;
						END IF;
					ELSIF(C20_OUT = '1') THEN
						COUNT_DUM <= '0';
					ELSE
						COUNT_DUM <= COUNT_DUM;
					END IF;
				END IF;
			END PROCESS;
		END RTL;




